% /************************************************************************
% * Name: readImage
% * Function: Read the Image database.
% * Input: fDir: the directory of the file.
% *        cNum: the index of the character which need to be read.   
% * Output: res: the handwriting content of the corresponding characters
% * Return:
% * Explain:
% * Amendant record			
% * Date          Edition       Modifier      Summary
% * 20/11/2009    V1.0          Shusen Zhou   Establish 
% ************************************************************************/
function res=readImage(fDir,cNum)
 % Open file, read the number of the characters in the file.    
   file_id = fopen(fDir, 'rb');  
   iNum=fread(file_id, 1, 'uint32');
   iHeight=fread(file_id, 1, 'uint8');
   iWidth=fread(file_id, 1, 'uint8');
   iSamples=iHeight*iWidth;
   
   maxIndex=max(cNum);
   if maxIndex>iNum
       disp('Error, the indexs are exceed the number of characters.');
       return;
   end
   minIndex=min(cNum);
   rNum=maxIndex-minIndex+1;
   dat=zeros(rNum,iSamples); 
   for i=1:minIndex-1
        fread(file_id, iSamples, 'uint8');    
   end  % one frame   
   
   for i=minIndex:maxIndex
        dat(i-minIndex+1,:) = fread(file_id, iSamples, 'uint8');    
   end  % one frame       
   fclose(file_id);
   res=dat(cNum-minIndex+1,:);   
end
